package gov.va.med.mhv.health.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name = "HEALTH_HISTORY_RECORD")
public class HealthHistoryRecord implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4364740810575117908L;

	@Id
	@Column(name = "HEALTH_HIST_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	// General Fields
	@Column(name = "RELATIONSHIP")
	private String relationship;

	@Column(name = "FIRST_NAME")
	private String firstName;

	@Column(name = "LAST_NAME")
	private String lastName;

	@Column(name = "LIVING")
	private Integer living;

	@Column(name = "COMMENTS")
	private String comments;

	// Airway/Breathing Conditions

	@Column(name = "AW_ASTHMA")
	private Integer awAsthma;

	@Column(name = "AW_BRONCHITIS")
	private Integer awBronchitis;

	@Column(name = "AW_COPD")
	private Integer awCOPD;

	@Column(name = "AW_EMPHYSEMA")
	private Integer awEmphysema;

	@Column(name = "AW_PNEUMONIA")
	private Integer awPneumonia;

	@Column(name = "AW_SOB")
	private Integer awSoB;

	@Column(name = "AW_TB")
	private Integer awTuberculosis;

	@Column(name = "AW_OTHER")
	private Integer awOther;

	// Allergy/Immune Systen Conditions

	@Column(name = "AL_ALLERGIES")
	private Integer alAllergies;

	@Column(name = "AL_LUPUS")
	private Integer alLupus;

	@Column(name = "AL_OTHER")
	private Integer alOther;

	// Alcohol Conditions

	@Column(name = "ALC_SOCIAL")
	private Integer alcSocial;

	@Column(name = "ALC_ONE_DRINK")
	private Integer alcOneDrink;

	@Column(name = "ALC_SIX_DRINKS")
	private Integer alcSixDrinks;

	@Column(name = "ALC_TWO_SHOTS")
	private Integer alcTwoShots;

	// Blood Disorders

	@Column(name = "BL_ANEMIA")
	private Integer blAnemia;

	@Column(name = "BL_BRUISING")
	private Integer blBruising;

	@Column(name = "BL_CLOTTING")
	private Integer blClotting;

	@Column(name = "BL_LEUKEMIA")
	private Integer blLeukemia;

	@Column(name = "BL_SICKLE_CELL")
	private Integer blSickleCell;

	@Column(name = "BL_OTHER")
	private Integer blOther;

	// Body Aches

	@Column(name = "BA_ARTHRITIS")
	private Integer baArthritis;

	@Column(name = "BA_FIBROMYALGIA")
	private Integer baFibromyalgia;

	@Column(name = "BA_JOINT_PAIN")
	private Integer baJointPain;

	@Column(name = "BA_LYME_DISEASE")
	private Integer baLymeDisease;

	@Column(name = "BA_OTHER")
	private Integer baOther;

	// Cancers

	@Column(name = "CA_BREAST")
	private Integer caBreast;

	@Column(name = "CA_BOWEL")
	private Integer caBowel;

	@Column(name = "CA_COLON")
	private Integer caColon;

	@Column(name = "CA_LUNG")
	private Integer caLung;

	@Column(name = "CA_OVARIAN")
	private Integer caOvarian;

	@Column(name = "CA_SKIN")
	private Integer caSkin;

	@Column(name = "CA_STOMACH")
	private Integer caStomach;

	@Column(name = "CA_PROSTATE")
	private Integer caProstate;

	@Column(name = "CA_OTHER")
	private Integer caOther;

	// Childhood Diseases

	@Column(name = "CH_CHCK_POX")
	private Integer chChickenPox;

	@Column(name = "CH_DIPHT")
	private Integer chDiphtheria;

	@Column(name = "CH_MEASLES")
	private Integer chMeasles;

	@Column(name = "CH_MUMPS")
	private Integer chMumps;

	@Column(name = "CH_WHOOP_COUGH")
	private Integer chWhoopingCough;

	@Column(name = "CH_OTHER")
	private Integer chOther;

	// Diabetes -

	@Column(name = "DB_TYPE1")
	private Integer dbType1;

	@Column(name = "DB_TYPE2")
	private Integer dbType2;

	@Column(name = "DB_TYPE3")
	private Integer dbType3;

	// Gallbladder

	@Column(name = "GB_DISEASE")
	private Integer gbDisease;

	@Column(name = "GB_STONES")
	private Integer gbStones;

	@Column(name = "GB_OTHER")
	private Integer gbOther;

	// Head, Eyes, etc.

	@Column(name = "HNT_CATARACTS")
	private Integer hntCataracts;

	@Column(name = "HNT_DIZZINESS")
	private Integer hntDizziness;

	@Column(name = "HNT_DYSLEXIA")
	private Integer hntDyslexia;

	@Column(name = "HNT_GLAUCOMA")
	private Integer hntGlaucoma;

	@Column(name = "HNT_HEARING_LOSS")
	private Integer hntHearingLoss;

	@Column(name = "HNT_MIGRAINE")
	private Integer hntMigraineHeadaches;

	@Column(name = "HNT_RET_PIGM")
	private Integer hntRetinitisPigmentosa;

	@Column(name = "HNT_OTHER")
	private Integer hntOther;

	// Heart/Cardiovascular

	@Column(name = "HE_ANGINA")
	private Integer heAngina;

	@Column(name = "HE_CONG_FAIL")
	private Integer heCongestiveFailure;

	@Column(name = "HE_ATTACK")
	private Integer heAttack;

	@Column(name = "HE_MURMUR")
	private Integer heMurmur;

	@Column(name = "HE_HIGH_CHOL")
	private Integer heHighCholesterol;

	@Column(name = "HE_HIGH_PRESS")
	private Integer heHighPressure;

	@Column(name = "HE_MITRAL_VALVE_PRO")
	private Integer heMitralValveProlapse;

	@Column(name = "HE_RHYTHM_ABNORM")
	private Integer heRhythmAbnormality;

	@Column(name = "HE_STROKE")
	private Integer heStroke;

	@Column(name = "HE_OTHER")
	private Integer heOther;

	// Kidney

	@Column(name = "KI_INFECTIONS")
	private Integer kiInfections;

	@Column(name = "KI_STONES")
	private Integer kiStones;

	@Column(name = "KI_RENAL_FAILURE")
	private Integer kiRenalFailure;

	@Column(name = "KI_OTHER")
	private Integer kiOther;

	// Liver

	@Column(name = "LI_HEP_A")
	private Integer liHepatitisA;

	@Column(name = "LI_HEP_B")
	private Integer liHepatitisB;

	@Column(name = "LI_HEP_C")
	private Integer liHepatitisC;

	@Column(name = "LI_CIRRHOSIS")
	private Integer liCirrhosis;

	@Column(name = "LI_OTHER")
	private Integer liOther;

	// Mood/Cognitive

	@Column(name = "MD_ANXIETY")
	private Integer mdAnxiety;

	@Column(name = "MD_BIPOLAR")
	private Integer mdBipolar;

	@Column(name = "MD_DEPRESSION")
	private Integer mdDepression;

	@Column(name = "MD_PARANOIA")
	private Integer mdParanoia;

	@Column(name = "MD_PTSD")
	private Integer mdPTSD;

	@Column(name = "MD_SCHIZ")
	private Integer mdSchizophrenia;

	@Column(name = "MD_OTHER")
	private Integer mdOther;

	// Mood/Cognitive

	@Column(name = "NV_EPILEPSY")
	private Integer nvEpilepsy;

	@Column(name = "NV_MS")
	private Integer nvMultipleSclerosis;

	@Column(name = "NV_NUMB")
	private Integer nvNumbness;

	@Column(name = "NV_PARALYSIS")
	private Integer nvParalysis;

	@Column(name = "NV_SEIZURES")
	private Integer nvSeizures;

	@Column(name = "NV_OTHER")
	private Integer nvOther;

	// Nose Bleeds

	@Column(name = "NV_ONE_PER_MONTH")
	private Integer nbOnePerMonth;

	@Column(name = "NV_ONE_PER_WEEK")
	private Integer nbOnePerWeek;

	@Column(name = "NV_ONE_PER_DAY")
	private Integer nbOnePerDay;

	// Pain

	@Column(name = "PN_BACK")
	private Integer pnBack;

	@Column(name = "PN_JOINT")
	private Integer pnJoint;

	@Column(name = "PN_MUSCLE")
	private Integer pnMuscle;

	@Column(name = "PN_LEG")
	private Integer pnLeg;

	@Column(name = "PN_OTHER")
	private Integer pnOther;

	// Skin Disorders

	@Column(name = "SK_ECZEMA")
	private Integer skEczema;

	@Column(name = "SK_PSORIASIS")
	private Integer skPsoriasis;

	@Column(name = "SK_OTHER")
	private Integer skOther;

	// Sleep Disorders

	@Column(name = "SL_INSOMNIA")
	private Integer slInsomnia;

	@Column(name = "SL_APNEA")
	private Integer slApnea;

	@Column(name = "SL_OTHER")
	private Integer slOther;

	// Smoking History

	@Column(name = "SM_CURRENT")
	private Integer smCurrent;

	@Column(name = "SM_ONE_PACK_DAY")
	private Integer smOnePackPerDay;

	@Column(name = "SM_TEN_YEARS")
	private Integer smTenYears;

	@Column(name = "SM_TWENTY_YEARS")
	private Integer smTwentyYears;

	// STDs

	@Column(name = "STD_CHLAMYDIA")
	private Integer stdChlamydia;

	@Column(name = "STD_GONORRHEA")
	private Integer stdGonorrhea;

	@Column(name = "STD_HERPES")
	private Integer stdHerpes;

	@Column(name = "STD_SYPHILIS")
	private Integer stdSyphilis;

	@Column(name = "STD_OTHER")
	private Integer stdOther;

	// Stomach, Bowel

	@Column(name = "STM_IBS")
	private Integer stmIBS;

	@Column(name = "STM_NAUSEA")
	private Integer stmNausea;

	@Column(name = "STM_PAIN")
	private Integer stmPain;

	@Column(name = "STM_SEV_INDIG")
	private Integer stmSevereIndigestion;

	@Column(name = "STM_ULCERS")
	private Integer stmUlcers;

	@Column(name = "STM_OTHER")
	private Integer stmOther;

	// Thyroid

	@Column(name = "TH_GOITER")
	private Integer thGoiter;

	@Column(name = "TH_TUMOR")
	private Integer thTumor;

	@Column(name = "TH_OTHER")
	private Integer thOther;

	// Weight

	@Column(name = "WT_OVER")
	private Integer wtOverweight;

	@Column(name = "WT_UNDER")
	private Integer wtUnderweight;

	@Column(name = "oplock")
	private Integer oplock = 0;

	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;

	@OneToMany(mappedBy = "healthHistoryRecord", cascade = CascadeType.ALL, fetch = FetchType.EAGER, orphanRemoval = true)
	@Fetch(FetchMode.SELECT)
	private List<OtherHealthIssue> otherHealthIssues;

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @return the relationship
	 */
	public String getRelationship() {
		return relationship;
	}

	/**
	 * @param relationship
	 *            the relationship to set
	 */
	public void setRelationship(String relationship) {
		this.relationship = relationship;
	}

	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * @param firstName
	 *            the firstName to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * @return the lastName
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * @param lastName
	 *            the lastName to set
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * @return the living
	 */
	public Integer getLiving() {
		return living;
	}

	/**
	 * @param living
	 *            the living to set
	 */
	public void setLiving(Boolean living) {
		this.living = living == true ? 1 : 0;
	}

	/**
	 * @return the comments
	 */
	public String getComments() {
		return comments;
	}

	/**
	 * @param comments
	 *            the comments to set
	 */
	public void setComments(String comments) {
		this.comments = comments == null ? "" : comments;
	}

	/**
	 * @return the awAsthma
	 */
	public Integer getAwAsthma() {
		return awAsthma;
	}

	/**
	 * @param awAsthma
	 *            the awAsthma to set
	 */
	public void setAwAsthma(Boolean awAsthma) {
		this.awAsthma = awAsthma == true ? 1 : 0;
	}

	/**
	 * @return the awBronchitis
	 */
	public Integer getAwBronchitis() {
		return awBronchitis;
	}

	/**
	 * @param awBronchitis
	 *            the awBronchitis to set
	 */
	public void setAwBronchitis(Boolean awBronchitis) {
		this.awBronchitis = awBronchitis == true ? 1 : 0;
	}

	/**
	 * @return the awCOPD
	 */
	public Integer getAwCOPD() {
		return awCOPD;
	}

	/**
	 * @param awCOPD
	 *            the awCOPD to set
	 */
	public void setAwCOPD(Boolean awCOPD) {
		this.awCOPD = awCOPD == true ? 1 : 0;
	}

	/**
	 * @return the awEmphysema
	 */
	public Integer getAwEmphysema() {
		return awEmphysema;
	}

	/**
	 * @param awEmphysema
	 *            the awEmphysema to set
	 */
	public void setAwEmphysema(Boolean awEmphysema) {
		this.awEmphysema = awEmphysema == true ? 1 : 0;
	}

	/**
	 * @return the awPneumonia
	 */
	public Integer getAwPneumonia() {
		return awPneumonia;
	}

	/**
	 * @param awPneumonia
	 *            the awPneumonia to set
	 */
	public void setAwPneumonia(Boolean awPneumonia) {
		this.awPneumonia = awPneumonia == true ? 1 : 0;
	}

	/**
	 * @return the awSoB
	 */
	public Integer getAwSoB() {
		return awSoB;
	}

	/**
	 * @param awSoB
	 *            the awSoB to set
	 */
	public void setAwSoB(Boolean awSoB) {
		this.awSoB = awSoB == true ? 1 : 0;
	}

	/**
	 * @return the awTuberculosis
	 */
	public Integer getAwTuberculosis() {
		return awTuberculosis;
	}

	/**
	 * @param awTuberculosis
	 *            the awTuberculosis to set
	 */
	public void setAwTuberculosis(Boolean awTuberculosis) {
		this.awTuberculosis = awTuberculosis == true ? 1 : 0;
	}

	/**
	 * @return the awOther
	 */
	public Integer getAwOther() {
		return awOther;
	}

	/**
	 * @param awOther
	 *            the awOther to set
	 */
	public void setAwOther(Boolean awOther) {
		this.awOther = awOther == true ? 1 : 0;
	}

	/**
	 * @return the alAllergies
	 */
	public Integer getAlAllergies() {
		return alAllergies;
	}

	/**
	 * @param alAllergies
	 *            the alAllergies to set
	 */
	public void setAlAllergies(Boolean alAllergies) {
		this.alAllergies = alAllergies == true ? 1 : 0;
	}

	/**
	 * @return the alLupus
	 */
	public Integer getAlLupus() {
		return alLupus;
	}

	/**
	 * @param alLupus
	 *            the alLupus to set
	 */
	public void setAlLupus(Boolean alLupus) {
		this.alLupus = alLupus == true ? 1 : 0;
	}

	/**
	 * @return the alOther
	 */
	public Integer getAlOther() {
		return alOther;
	}

	/**
	 * @param alOther
	 *            the alOther to set
	 */
	public void setAlOther(Boolean alOther) {
		this.alOther = alOther == true ? 1 : 0;
	}

	/**
	 * @return the alcSocial
	 */
	public Integer getAlcSocial() {
		return alcSocial;
	}

	/**
	 * @param alcSocial
	 *            the alcSocial to set
	 */
	public void setAlcSocial(Boolean alcSocial) {
		this.alcSocial = alcSocial == true ? 1 : 0;
	}

	/**
	 * @return the alcOneDrink
	 */
	public Integer getAlcOneDrink() {
		return alcOneDrink;
	}

	/**
	 * @param alcOneDrink
	 *            the alcOneDrink to set
	 */
	public void setAlcOneDrink(Boolean alcOneDrink) {
		this.alcOneDrink = alcOneDrink == true ? 1 : 0;
	}

	/**
	 * @return the alcSixDrinks
	 */
	public Integer getAlcSixDrinks() {
		return alcSixDrinks;
	}

	/**
	 * @param alcSixDrinks
	 *            the alcSixDrinks to set
	 */
	public void setAlcSixDrinks(Boolean alcSixDrinks) {
		this.alcSixDrinks = alcSixDrinks == true ? 1 : 0;
	}

	/**
	 * @return the alcTwoShots
	 */
	public Integer getAlcTwoShots() {
		return alcTwoShots;
	}

	/**
	 * @param alcTwoShots
	 *            the alcTwoShots to set
	 */
	public void setAlcTwoShots(Boolean alcTwoShots) {
		this.alcTwoShots = alcTwoShots == true ? 1 : 0;
	}

	/**
	 * @return the blAnemia
	 */
	public Integer getBlAnemia() {
		return blAnemia;
	}

	/**
	 * @param blAnemia
	 *            the blAnemia to set
	 */
	public void setBlAnemia(Boolean blAnemia) {
		this.blAnemia = blAnemia == true ? 1 : 0;
	}

	/**
	 * @return the blBruising
	 */
	public Integer getBlBruising() {
		return blBruising;
	}

	/**
	 * @param blBruising
	 *            the blBruising to set
	 */
	public void setBlBruising(Boolean blBruising) {
		this.blBruising = blBruising == true ? 1 : 0;
	}

	/**
	 * @return the blClotting
	 */
	public Integer getBlClotting() {
		return blClotting;
	}

	/**
	 * @param blClotting
	 *            the blClotting to set
	 */
	public void setBlClotting(Boolean blClotting) {
		this.blClotting = blClotting == true ? 1 : 0;
	}

	/**
	 * @return the blLeukemia
	 */
	public Integer getBlLeukemia() {
		return blLeukemia;
	}

	/**
	 * @param blLeukemia
	 *            the blLeukemia to set
	 */
	public void setBlLeukemia(Boolean blLeukemia) {
		this.blLeukemia = blLeukemia == true ? 1 : 0;
	}

	/**
	 * @return the blSickleCell
	 */
	public Integer getBlSickleCell() {
		return blSickleCell;
	}

	/**
	 * @param blSickleCell
	 *            the blSickleCell to set
	 */
	public void setBlSickleCell(Boolean blSickleCell) {
		this.blSickleCell = blSickleCell == true ? 1 : 0;
	}

	/**
	 * @return the blOther
	 */
	public Integer getBlOther() {
		return blOther;
	}

	/**
	 * @param blOther
	 *            the blOther to set
	 */
	public void setBlOther(Boolean blOther) {
		this.blOther = blOther == true ? 1 : 0;
	}

	/**
	 * @return the baArthritis
	 */
	public Integer getBaArthritis() {
		return baArthritis;
	}

	/**
	 * @param baArthritis
	 *            the baArthritis to set
	 */
	public void setBaArthritis(Boolean baArthritis) {
		this.baArthritis = baArthritis == true ? 1 : 0;
	}

	/**
	 * @return the baFibromyalgia
	 */
	public Integer getBaFibromyalgia() {
		return baFibromyalgia;
	}

	/**
	 * @param baFibromyalgia
	 *            the baFibromyalgia to set
	 */
	public void setBaFibromyalgia(Boolean baFibromyalgia) {
		this.baFibromyalgia = baFibromyalgia == true ? 1 : 0;
	}

	/**
	 * @return the baJointPain
	 */
	public Integer getBaJointPain() {
		return baJointPain;
	}

	/**
	 * @param baJointPain
	 *            the baJointPain to set
	 */
	public void setBaJointPain(Boolean baJointPain) {
		this.baJointPain = baJointPain == true ? 1 : 0;
	}

	/**
	 * @return the baLymeDisease
	 */
	public Integer getBaLymeDisease() {
		return baLymeDisease;
	}

	/**
	 * @param baLymeDisease
	 *            the baLymeDisease to set
	 */
	public void setBaLymeDisease(Boolean baLymeDisease) {
		this.baLymeDisease = baLymeDisease == true ? 1 : 0;
	}

	/**
	 * @return the baOther
	 */
	public Integer getBaOther() {
		return baOther;
	}

	/**
	 * @param baOther
	 *            the baOther to set
	 */
	public void setBaOther(Boolean baOther) {
		this.baOther = baOther == true ? 1 : 0;
	}

	/**
	 * @return the caBreast
	 */
	public Integer getCaBreast() {
		return caBreast;
	}

	/**
	 * @param caBreast
	 *            the caBreast to set
	 */
	public void setCaBreast(Boolean caBreast) {
		this.caBreast = caBreast == true ? 1 : 0;
	}

	/**
	 * @return the caBowel
	 */
	public Integer getCaBowel() {
		return caBowel;
	}

	/**
	 * @param caBowel
	 *            the caBowel to set
	 */
	public void setCaBowel(Boolean caBowel) {
		this.caBowel = caBowel == true ? 1 : 0;
	}

	/**
	 * @return the caColon
	 */
	public Integer getCaColon() {
		return caColon;
	}

	/**
	 * @param caColon
	 *            the caColon to set
	 */
	public void setCaColon(Boolean caColon) {
		this.caColon = caColon == true ? 1 : 0;
	}

	/**
	 * @return the caLung
	 */
	public Integer getCaLung() {
		return caLung;
	}

	/**
	 * @param caLung
	 *            the caLung to set
	 */
	public void setCaLung(Boolean caLung) {
		this.caLung = caLung == true ? 1 : 0;
	}

	/**
	 * @return the caOvarian
	 */
	public Integer getCaOvarian() {
		return caOvarian;
	}

	/**
	 * @param caOvarian
	 *            the caOvarian to set
	 */
	public void setCaOvarian(Boolean caOvarian) {
		this.caOvarian = caOvarian == true ? 1 : 0;
	}

	/**
	 * @return the caSkin
	 */
	public Integer getCaSkin() {
		return caSkin;
	}

	/**
	 * @param caSkin
	 *            the caSkin to set
	 */
	public void setCaSkin(Boolean caSkin) {
		this.caSkin = caSkin == true ? 1 : 0;
	}

	/**
	 * @return the caStomach
	 */
	public Integer getCaStomach() {
		return caStomach;
	}

	/**
	 * @param caStomach
	 *            the caStomach to set
	 */
	public void setCaStomach(Boolean caStomach) {
		this.caStomach = caStomach == true ? 1 : 0;
	}

	/**
	 * @return the caProstate
	 */
	public Integer getCaProstate() {
		return caProstate;
	}

	/**
	 * @param caProstate
	 *            the caProstate to set
	 */
	public void setCaProstate(Boolean caProstate) {
		this.caProstate = caProstate == true ? 1 : 0;
	}

	/**
	 * @return the caOther
	 */
	public Integer getCaOther() {
		return caOther;
	}

	/**
	 * @param caOther
	 *            the caOther to set
	 */
	public void setCaOther(Boolean caOther) {
		this.caOther = caOther == true ? 1 : 0;
	}

	/**
	 * @return the chChickenPox
	 */
	public Integer getChChickenPox() {
		return chChickenPox;
	}

	/**
	 * @param chChickenPox
	 *            the chChickenPox to set
	 */
	public void setChChickenPox(Boolean chChickenPox) {
		this.chChickenPox = chChickenPox == true ? 1 : 0;
	}

	/**
	 * @return the chDiphtheria
	 */
	public Integer getChDiphtheria() {
		return chDiphtheria;
	}

	/**
	 * @param chDiphtheria
	 *            the chDiphtheria to set
	 */
	public void setChDiphtheria(Boolean chDiphtheria) {
		this.chDiphtheria = chDiphtheria == true ? 1 : 0;
	}

	/**
	 * @return the chMeasles
	 */
	public Integer getChMeasles() {
		return chMeasles;
	}

	/**
	 * @param chMeasles
	 *            the chMeasles to set
	 */
	public void setChMeasles(Boolean chMeasles) {
		this.chMeasles = chMeasles == true ? 1 : 0;
	}

	/**
	 * @return the chMumps
	 */
	public Integer getChMumps() {
		return chMumps;
	}

	/**
	 * @param chMumps
	 *            the chMumps to set
	 */
	public void setChMumps(Boolean chMumps) {
		this.chMumps = chMumps == true ? 1 : 0;
	}

	/**
	 * @return the chWhoopingCough
	 */
	public Integer getChWhoopingCough() {
		return chWhoopingCough;
	}

	/**
	 * @param chWhoopingCough
	 *            the chWhoopingCough to set
	 */
	public void setChWhoopingCough(Boolean chWhoopingCough) {
		this.chWhoopingCough = chWhoopingCough == true ? 1 : 0;
	}

	/**
	 * @return the chOther
	 */
	public Integer getChOther() {
		return chOther;
	}

	/**
	 * @param chOther
	 *            the chOther to set
	 */
	public void setChOther(Boolean chOther) {
		this.chOther = chOther == true ? 1 : 0;
	}

	/**
	 * @return the dbType1
	 */
	public Integer getDbType1() {
		return dbType1;
	}

	/**
	 * @param dbType1
	 *            the dbType1 to set
	 */
	public void setDbType1(Boolean dbType1) {
		this.dbType1 = dbType1 == true ? 1 : 0;
	}

	/**
	 * @return the dbType2
	 */
	public Integer getDbType2() {
		return dbType2;
	}

	/**
	 * @param dbType2
	 *            the dbType2 to set
	 */
	public void setDbType2(Boolean dbType2) {
		this.dbType2 = dbType2 == true ? 1 : 0;
	}

	/**
	 * @return the dbType3
	 */
	public Integer getDbType3() {
		return dbType3;
	}

	/**
	 * @param dbType3
	 *            the dbType3 to set
	 */
	public void setDbType3(Boolean dbType3) {
		this.dbType3 = dbType3 == true ? 1 : 0;
	}

	/**
	 * @return the gbDisease
	 */
	public Integer getGbDisease() {
		return gbDisease;
	}

	/**
	 * @param gbDisease
	 *            the gbDisease to set
	 */
	public void setGbDisease(Boolean gbDisease) {
		this.gbDisease = gbDisease == true ? 1 : 0;
	}

	/**
	 * @return the gbStones
	 */
	public Integer getGbStones() {
		return gbStones;
	}

	/**
	 * @param gbStones
	 *            the gbStones to set
	 */
	public void setGbStones(Boolean gbStones) {
		this.gbStones = gbStones == true ? 1 : 0;
	}

	/**
	 * @return the gbOther
	 */
	public Integer getGbOther() {
		return gbOther;
	}

	/**
	 * @param gbOther
	 *            the gbOther to set
	 */
	public void setGbOther(Boolean gbOther) {
		this.gbOther = gbOther == true ? 1 : 0;
	}

	/**
	 * @return the hntCataracts
	 */
	public Integer getHntCataracts() {
		return hntCataracts;
	}

	/**
	 * @param hntCataracts
	 *            the hntCataracts to set
	 */
	public void setHntCataracts(Boolean hntCataracts) {
		this.hntCataracts = hntCataracts == true ? 1 : 0;
	}

	/**
	 * @return the hntDizziness
	 */
	public Integer getHntDizziness() {
		return hntDizziness;
	}

	/**
	 * @param hntDizziness
	 *            the hntDizziness to set
	 */
	public void setHntDizziness(Boolean hntDizziness) {
		this.hntDizziness = hntDizziness == true ? 1 : 0;
	}

	/**
	 * @return the hntDyslexia
	 */
	public Integer getHntDyslexia() {
		return hntDyslexia;
	}

	/**
	 * @param hntDyslexia
	 *            the hntDyslexia to set
	 */
	public void setHntDyslexia(Boolean hntDyslexia) {
		this.hntDyslexia = hntDyslexia == true ? 1 : 0;
	}

	/**
	 * @return the hntGlaucoma
	 */
	public Integer getHntGlaucoma() {
		return hntGlaucoma;
	}

	/**
	 * @param hntGlaucoma
	 *            the hntGlaucoma to set
	 */
	public void setHntGlaucoma(Boolean hntGlaucoma) {
		this.hntGlaucoma = hntGlaucoma == true ? 1 : 0;
	}

	/**
	 * @return the hntHearingLoss
	 */
	public Integer getHntHearingLoss() {
		return hntHearingLoss;
	}

	/**
	 * @param hntHearingLoss
	 *            the hntHearingLoss to set
	 */
	public void setHntHearingLoss(Boolean hntHearingLoss) {
		this.hntHearingLoss = hntHearingLoss == true ? 1 : 0;
	}

	/**
	 * @return the hntMigraineHeadaches
	 */
	public Integer getHntMigraineHeadaches() {
		return hntMigraineHeadaches;
	}

	/**
	 * @param hntMigraineHeadaches
	 *            the hntMigraineHeadaches to set
	 */
	public void setHntMigraineHeadaches(Boolean hntMigraineHeadaches) {
		this.hntMigraineHeadaches = hntMigraineHeadaches == true ? 1 : 0;
	}

	/**
	 * @return the hntRetinitisPigmentosa
	 */
	public Integer getHntRetinitisPigmentosa() {
		return hntRetinitisPigmentosa;
	}

	/**
	 * @param hntRetinitisPigmentosa
	 *            the hntRetinitisPigmentosa to set
	 */
	public void setHntRetinitisPigmentosa(Boolean hntRetinitisPigmentosa) {
		this.hntRetinitisPigmentosa = hntRetinitisPigmentosa == true ? 1 : 0;
	}

	/**
	 * @return the hntOther
	 */
	public Integer getHntOther() {
		return hntOther;
	}

	/**
	 * @param hntOther
	 *            the hntOther to set
	 */
	public void setHntOther(Boolean hntOther) {
		this.hntOther = hntOther == true ? 1 : 0;
	}

	/**
	 * @return the heAngina
	 */
	public Integer getHeAngina() {
		return heAngina;
	}

	/**
	 * @param heAngina
	 *            the heAngina to set
	 */
	public void setHeAngina(Boolean heAngina) {
		this.heAngina = heAngina == true ? 1 : 0;
	}

	/**
	 * @return the heCongestiveFailure
	 */
	public Integer getHeCongestiveFailure() {
		return heCongestiveFailure;
	}

	/**
	 * @param heCongestiveFailure
	 *            the heCongestiveFailure to set
	 */
	public void setHeCongestiveFailure(Boolean heCongestiveFailure) {
		this.heCongestiveFailure = heCongestiveFailure == true ? 1 : 0;
	}

	/**
	 * @return the heAttack
	 */
	public Integer getHeAttack() {
		return heAttack;
	}

	/**
	 * @param heAttack
	 *            the heAttack to set
	 */
	public void setHeAttack(Boolean heAttack) {
		this.heAttack = heAttack == true ? 1 : 0;
	}

	/**
	 * @return the heMurmur
	 */
	public Integer getHeMurmur() {
		return heMurmur;
	}

	/**
	 * @param heMurmur
	 *            the heMurmur to set
	 */
	public void setHeMurmur(Boolean heMurmur) {
		this.heMurmur = heMurmur == true ? 1 : 0;
	}

	/**
	 * @return the heHighCholesterol
	 */
	public Integer getHeHighCholesterol() {
		return heHighCholesterol;
	}

	/**
	 * @param heHighCholesterol
	 *            the heHighCholesterol to set
	 */
	public void setHeHighCholesterol(Boolean heHighCholesterol) {
		this.heHighCholesterol = heHighCholesterol == true ? 1 : 0;
	}

	/**
	 * @return the heHighPressure
	 */
	public Integer getHeHighPressure() {
		return heHighPressure;
	}

	/**
	 * @param heHighPressure
	 *            the heHighPressure to set
	 */
	public void setHeHighPressure(Boolean heHighPressure) {
		this.heHighPressure = heHighPressure == true ? 1 : 0;
	}

	/**
	 * @return the heMitralValveProlapse
	 */
	public Integer getHeMitralValveProlapse() {
		return heMitralValveProlapse;
	}

	/**
	 * @param heMitralValveProlapse
	 *            the heMitralValveProlapse to set
	 */
	public void setHeMitralValveProlapse(Boolean heMitralValveProlapse) {
		this.heMitralValveProlapse = heMitralValveProlapse == true ? 1 : 0;
	}

	/**
	 * @return the heRhythmAbnormality
	 */
	public Integer getHeRhythmAbnormality() {
		return heRhythmAbnormality;
	}

	/**
	 * @param heRhythmAbnormality
	 *            the heRhythmAbnormality to set
	 */
	public void setHeRhythmAbnormality(Boolean heRhythmAbnormality) {
		this.heRhythmAbnormality = heRhythmAbnormality == true ? 1 : 0;
	}

	/**
	 * @return the heStroke
	 */
	public Integer getHeStroke() {
		return heStroke;
	}

	/**
	 * @param heStroke
	 *            the heStroke to set
	 */
	public void setHeStroke(Boolean heStroke) {
		this.heStroke = heStroke == true ? 1 : 0;
	}

	/**
	 * @return the heOther
	 */
	public Integer getHeOther() {
		return heOther;
	}

	/**
	 * @param heOther
	 *            the heOther to set
	 */
	public void setHeOther(Boolean heOther) {
		this.heOther = heOther == true ? 1 : 0;
	}

	/**
	 * @return the kiInfections
	 */
	public Integer getKiInfections() {
		return kiInfections;
	}

	/**
	 * @param kiInfections
	 *            the kiInfections to set
	 */
	public void setKiInfections(Boolean kiInfections) {
		this.kiInfections = kiInfections == true ? 1 : 0;
	}

	/**
	 * @return the kiStones
	 */
	public Integer getKiStones() {
		return kiStones;
	}

	/**
	 * @param kiStones
	 *            the kiStones to set
	 */
	public void setKiStones(Boolean kiStones) {
		this.kiStones = kiStones == true ? 1 : 0;
	}

	/**
	 * @return the kiRenalFailure
	 */
	public Integer getKiRenalFailure() {
		return kiRenalFailure;
	}

	/**
	 * @param kiRenalFailure
	 *            the kiRenalFailure to set
	 */
	public void setKiRenalFailure(Boolean kiRenalFailure) {
		this.kiRenalFailure = kiRenalFailure == true ? 1 : 0;
	}

	/**
	 * @return the kiOther
	 */
	public Integer getKiOther() {
		return kiOther;
	}

	/**
	 * @param kiOther
	 *            the kiOther to set
	 */
	public void setKiOther(Boolean kiOther) {
		this.kiOther = kiOther == true ? 1 : 0;
	}

	/**
	 * @return the liHepatitisA
	 */
	public Integer getLiHepatitisA() {
		return liHepatitisA;
	}

	/**
	 * @param liHepatitisA
	 *            the liHepatitisA to set
	 */
	public void setLiHepatitisA(Boolean liHepatitisA) {
		this.liHepatitisA = liHepatitisA == true ? 1 : 0;
	}

	/**
	 * @return the liHepatitisB
	 */
	public Integer getLiHepatitisB() {
		return liHepatitisB;
	}

	/**
	 * @param liHepatitisB
	 *            the liHepatitisB to set
	 */
	public void setLiHepatitisB(Boolean liHepatitisB) {
		this.liHepatitisB = liHepatitisB == true ? 1 : 0;
	}

	/**
	 * @return the liHepatitisC
	 */
	public Integer getLiHepatitisC() {
		return liHepatitisC;
	}

	/**
	 * @param liHepatitisC
	 *            the liHepatitisC to set
	 */
	public void setLiHepatitisC(Boolean liHepatitisC) {
		this.liHepatitisC = liHepatitisC == true ? 1 : 0;
	}

	/**
	 * @return the liCirrhosis
	 */
	public Integer getLiCirrhosis() {
		return liCirrhosis;
	}

	/**
	 * @param liCirrhosis
	 *            the liCirrhosis to set
	 */
	public void setLiCirrhosis(Boolean liCirrhosis) {
		this.liCirrhosis = liCirrhosis == true ? 1 : 0;
	}

	/**
	 * @return the liOther
	 */
	public Integer getLiOther() {
		return liOther;
	}

	/**
	 * @param liOther
	 *            the liOther to set
	 */
	public void setLiOther(Boolean liOther) {
		this.liOther = liOther == true ? 1 : 0;
	}

	/**
	 * @return the mdAnxiety
	 */
	public Integer getMdAnxiety() {
		return mdAnxiety;
	}

	/**
	 * @param mdAnxiety
	 *            the mdAnxiety to set
	 */
	public void setMdAnxiety(Boolean mdAnxiety) {
		this.mdAnxiety = mdAnxiety == true ? 1 : 0;
	}

	/**
	 * @return the mdBipolar
	 */
	public Integer getMdBipolar() {
		return mdBipolar;
	}

	/**
	 * @param mdBipolar
	 *            the mdBipolar to set
	 */
	public void setMdBipolar(Boolean mdBipolar) {
		this.mdBipolar = mdBipolar == true ? 1 : 0;
	}

	/**
	 * @return the mdDepression
	 */
	public Integer getMdDepression() {
		return mdDepression;
	}

	/**
	 * @param mdDepression
	 *            the mdDepression to set
	 */
	public void setMdDepression(Boolean mdDepression) {
		this.mdDepression = mdDepression == true ? 1 : 0;
	}

	/**
	 * @return the mdParanoia
	 */
	public Integer getMdParanoia() {
		return mdParanoia;
	}

	/**
	 * @param mdParanoia
	 *            the mdParanoia to set
	 */
	public void setMdParanoia(Boolean mdParanoia) {
		this.mdParanoia = mdParanoia == true ? 1 : 0;
	}

	/**
	 * @return the mdPTSD
	 */
	public Integer getMdPTSD() {
		return mdPTSD;
	}

	/**
	 * @param mdPTSD
	 *            the mdPTSD to set
	 */
	public void setMdPTSD(Boolean mdPTSD) {
		this.mdPTSD = mdPTSD == true ? 1 : 0;
	}

	/**
	 * @return the mdSchizophrenia
	 */
	public Integer getMdSchizophrenia() {
		return mdSchizophrenia;
	}

	/**
	 * @param mdSchizophrenia
	 *            the mdSchizophrenia to set
	 */
	public void setMdSchizophrenia(Boolean mdSchizophrenia) {
		this.mdSchizophrenia = mdSchizophrenia == true ? 1 : 0;
	}

	/**
	 * @return the mdOther
	 */
	public Integer getMdOther() {
		return mdOther;
	}

	/**
	 * @param mdOther
	 *            the mdOther to set
	 */
	public void setMdOther(Boolean mdOther) {
		this.mdOther = mdOther == true ? 1 : 0;
	}

	/**
	 * @return the nvEpilepsy
	 */
	public Integer getNvEpilepsy() {
		return nvEpilepsy;
	}

	/**
	 * @param nvEpilepsy
	 *            the nvEpilepsy to set
	 */
	public void setNvEpilepsy(Boolean nvEpilepsy) {
		this.nvEpilepsy = nvEpilepsy == true ? 1 : 0;
	}

	/**
	 * @return the nvMultipleSclerosis
	 */
	public Integer getNvMultipleSclerosis() {
		return nvMultipleSclerosis;
	}

	/**
	 * @param nvMultipleSclerosis
	 *            the nvMultipleSclerosis to set
	 */
	public void setNvMultipleSclerosis(Boolean nvMultipleSclerosis) {
		this.nvMultipleSclerosis = nvMultipleSclerosis == true ? 1 : 0;
	}

	/**
	 * @return the nvNumbness
	 */
	public Integer getNvNumbness() {
		return nvNumbness;
	}

	/**
	 * @param nvNumbness
	 *            the nvNumbness to set
	 */
	public void setNvNumbness(Boolean nvNumbness) {
		this.nvNumbness = nvNumbness == true ? 1 : 0;
	}

	/**
	 * @return the nvParalysis
	 */
	public Integer getNvParalysis() {
		return nvParalysis;
	}

	/**
	 * @param nvParalysis
	 *            the nvParalysis to set
	 */
	public void setNvParalysis(Boolean nvParalysis) {
		this.nvParalysis = nvParalysis == true ? 1 : 0;
	}

	/**
	 * @return the nvSeizures
	 */
	public Integer getNvSeizures() {
		return nvSeizures;
	}

	/**
	 * @param nvSeizures
	 *            the nvSeizures to set
	 */
	public void setNvSeizures(Boolean nvSeizures) {
		this.nvSeizures = nvSeizures == true ? 1 : 0;
	}

	/**
	 * @return the nvOther
	 */
	public Integer getNvOther() {
		return nvOther;
	}

	/**
	 * @param nvOther
	 *            the nvOther to set
	 */
	public void setNvOther(Boolean nvOther) {
		this.nvOther = nvOther == true ? 1 : 0;
	}

	/**
	 * @return the nbOnePerMonth
	 */
	public Integer getNbOnePerMonth() {
		return nbOnePerMonth;
	}

	/**
	 * @param nbOnePerMonth
	 *            the nbOnePerMonth to set
	 */
	public void setNbOnePerMonth(Boolean nbOnePerMonth) {
		this.nbOnePerMonth = nbOnePerMonth == true ? 1 : 0;
	}

	/**
	 * @return the nbOnePerWeek
	 */
	public Integer getNbOnePerWeek() {
		return nbOnePerWeek;
	}

	/**
	 * @param nbOnePerWeek
	 *            the nbOnePerWeek to set
	 */
	public void setNbOnePerWeek(Boolean nbOnePerWeek) {
		this.nbOnePerWeek = nbOnePerWeek == true ? 1 : 0;
	}

	/**
	 * @return the nbOnePerDay
	 */
	public Integer getNbOnePerDay() {
		return nbOnePerDay;
	}

	/**
	 * @param nbOnePerDay
	 *            the nbOnePerDay to set
	 */
	public void setNbOnePerDay(Boolean nbOnePerDay) {
		this.nbOnePerDay = nbOnePerDay == true ? 1 : 0;
	}

	/**
	 * @return the pnBack
	 */
	public Integer getPnBack() {
		return pnBack;
	}

	/**
	 * @param pnBack
	 *            the pnBack to set
	 */
	public void setPnBack(Boolean pnBack) {
		this.pnBack = pnBack == true ? 1 : 0;
	}

	/**
	 * @return the pnJoint
	 */
	public Integer getPnJoint() {
		return pnJoint;
	}

	/**
	 * @param pnJoint
	 *            the pnJoint to set
	 */
	public void setPnJoint(Boolean pnJoint) {
		this.pnJoint = pnJoint == true ? 1 : 0;
	}

	/**
	 * @return the pnMuscle
	 */
	public Integer getPnMuscle() {
		return pnMuscle;
	}

	/**
	 * @param pnMuscle
	 *            the pnMuscle to set
	 */
	public void setPnMuscle(Boolean pnMuscle) {
		this.pnMuscle = pnMuscle == true ? 1 : 0;
	}

	/**
	 * @return the pnLeg
	 */
	public Integer getPnLeg() {
		return pnLeg;
	}

	/**
	 * @param pnLeg
	 *            the pnLeg to set
	 */
	public void setPnLeg(Boolean pnLeg) {
		this.pnLeg = pnLeg == true ? 1 : 0;
	}

	/**
	 * @return the pnOther
	 */
	public Integer getPnOther() {
		return pnOther;
	}

	/**
	 * @param pnOther
	 *            the pnOther to set
	 */
	public void setPnOther(Boolean pnOther) {
		this.pnOther = pnOther == true ? 1 : 0;
	}

	/**
	 * @return the skEczema
	 */
	public Integer getSkEczema() {
		return skEczema;
	}

	/**
	 * @param skEczema
	 *            the skEczema to set
	 */
	public void setSkEczema(Boolean skEczema) {
		this.skEczema = skEczema == true ? 1 : 0;
	}

	/**
	 * @return the skPsoriasis
	 */
	public Integer getSkPsoriasis() {
		return skPsoriasis;
	}

	/**
	 * @param skPsoriasis
	 *            the skPsoriasis to set
	 */
	public void setSkPsoriasis(Boolean skPsoriasis) {
		this.skPsoriasis = skPsoriasis == true ? 1 : 0;
	}

	/**
	 * @return the skOther
	 */
	public Integer getSkOther() {
		return skOther;
	}

	/**
	 * @param skOther
	 *            the skOther to set
	 */
	public void setSkOther(Boolean skOther) {
		this.skOther = skOther == true ? 1 : 0;
	}

	/**
	 * @return the slInsomnia
	 */
	public Integer getSlInsomnia() {
		return slInsomnia;
	}

	/**
	 * @param slInsomnia
	 *            the slInsomnia to set
	 */
	public void setSlInsomnia(Boolean slInsomnia) {
		this.slInsomnia = slInsomnia == true ? 1 : 0;
	}

	/**
	 * @return the slApnea
	 */
	public Integer getSlApnea() {
		return slApnea;
	}

	/**
	 * @param slApneal
	 *            the slApnea to set
	 */
	public void setSlApnea(Boolean slApnea) {
		this.slApnea = slApnea == true ? 1 : 0;
	}

	/**
	 * @return the slOther
	 */
	public Integer getSlOther() {
		return slOther;
	}

	/**
	 * @param slOther
	 *            the slOther to set
	 */
	public void setSlOther(Boolean slOther) {
		this.slOther = slOther == true ? 1 : 0;
	}

	/**
	 * @return the smCurrent
	 */
	public Integer getSmCurrent() {
		return smCurrent;
	}

	/**
	 * @param smCurrent
	 *            the smCurrent to set
	 */
	public void setSmCurrent(Boolean smCurrent) {
		this.smCurrent = smCurrent == true ? 1 : 0;
	}

	/**
	 * @return the smOnePackPerDay
	 */
	public Integer getSmOnePackPerDay() {
		return smOnePackPerDay;
	}

	/**
	 * @param smOnePackPerDay
	 *            the smOnePackPerDay to set
	 */
	public void setSmOnePackPerDay(Boolean smOnePackPerDay) {
		this.smOnePackPerDay = smOnePackPerDay == true ? 1 : 0;
	}

	/**
	 * @return the smTenYears
	 */
	public Integer getSmTenYears() {
		return smTenYears;
	}

	/**
	 * @param smTenYears
	 *            the smTenYears to set
	 */
	public void setSmTenYears(Boolean smTenYears) {
		this.smTenYears = smTenYears == true ? 1 : 0;
	}

	/**
	 * @return the smTwentyYears
	 */
	public Integer getSmTwentyYears() {
		return smTwentyYears;
	}

	/**
	 * @param smTwentyYears
	 *            the smTwentyYears to set
	 */
	public void setSmTwentyYears(Boolean smTwentyYears) {
		this.smTwentyYears = smTwentyYears == true ? 1 : 0;
	}

	/**
	 * @return the stdChlamydia
	 */
	public Integer getStdChlamydia() {
		return stdChlamydia;
	}

	/**
	 * @param stdChlamydia
	 *            the stdChlamydia to set
	 */
	public void setStdChlamydia(Boolean stdChlamydia) {
		this.stdChlamydia = stdChlamydia == true ? 1 : 0;
	}

	/**
	 * @return the stdGonorrhea
	 */
	public Integer getStdGonorrhea() {
		return stdGonorrhea;
	}

	/**
	 * @param stdGonorrhea
	 *            the stdGonorrhea to set
	 */
	public void setStdGonorrhea(Boolean stdGonorrhea) {
		this.stdGonorrhea = stdGonorrhea == true ? 1 : 0;
	}

	/**
	 * @return the stdHerpes
	 */
	public Integer getStdHerpes() {
		return stdHerpes;
	}

	/**
	 * @param stdHerpes
	 *            the stdHerpes to set
	 */
	public void setStdHerpes(Boolean stdHerpes) {
		this.stdHerpes = stdHerpes == true ? 1 : 0;
	}

	/**
	 * @return the stdSyphilis
	 */
	public Integer getStdSyphilis() {
		return stdSyphilis;
	}

	/**
	 * @param stdSyphilis
	 *            the stdSyphilis to set
	 */
	public void setStdSyphilis(Boolean stdSyphilis) {
		this.stdSyphilis = stdSyphilis == true ? 1 : 0;
	}

	/**
	 * @return the stdOther
	 */
	public Integer getStdOther() {
		return stdOther;
	}

	/**
	 * @param stdOther
	 *            the stdOther to set
	 */
	public void setStdOther(Boolean stdOther) {
		this.stdOther = stdOther == true ? 1 : 0;
	}

	/**
	 * @return the stmIBS
	 */
	public Integer getStmIBS() {
		return stmIBS;
	}

	/**
	 * @param stmIBS
	 *            the stmIBS to set
	 */
	public void setStmIBS(Boolean stmIBS) {
		this.stmIBS = stmIBS == true ? 1 : 0;
	}

	/**
	 * @return the stmNausea
	 */
	public Integer getStmNausea() {
		return stmNausea;
	}

	/**
	 * @param stmNausea
	 *            the stmNausea to set
	 */
	public void setStmNausea(Boolean stmNausea) {
		this.stmNausea = stmNausea == true ? 1 : 0;
	}

	/**
	 * @return the stmPain
	 */
	public Integer getStmPain() {
		return stmPain;
	}

	/**
	 * @param stmPain
	 *            the stmPain to set
	 */
	public void setStmPain(Boolean stmPain) {
		this.stmPain = stmPain == true ? 1 : 0;
	}

	/**
	 * @return the stmSevereIndigestion
	 */
	public Integer getStmSevereIndigestion() {
		return stmSevereIndigestion;
	}

	/**
	 * @param stmSevereIndigestion
	 *            the stmSevereIndigestionl to set
	 */
	public void setStmSevereIndigestion(Boolean stmSevereIndigestion) {
		this.stmSevereIndigestion = stmSevereIndigestion == true ? 1 : 0;
	}

	/**
	 * @return the stmUlcers
	 */
	public Integer getStmUlcers() {
		return stmUlcers;
	}

	/**
	 * @param stmUlcers
	 *            the stmUlcers to set
	 */
	public void setStmUlcers(Boolean stmUlcers) {
		this.stmUlcers = stmUlcers == true ? 1 : 0;
	}

	/**
	 * @return the stmOther
	 */
	public Integer getStmOther() {
		return stmOther;
	}

	/**
	 * @param stmOther
	 *            the stmOther to set
	 */
	public void setStmOther(Boolean stmOther) {
		this.stmOther = stmOther == true ? 1 : 0;
	}

	/**
	 * @return the thGoiter
	 */
	public Integer getThGoiter() {
		return thGoiter;
	}

	/**
	 * @param thGoiter
	 *            the thGoiter to set
	 */
	public void setThGoiter(Boolean thGoiter) {
		this.thGoiter = thGoiter == true ? 1 : 0;
	}

	/**
	 * @return the thTumor
	 */
	public Integer getThTumor() {
		return thTumor;
	}

	/**
	 * @param thTumor
	 *            the thTumor to set
	 */
	public void setThTumor(Boolean thTumor) {
		this.thTumor = thTumor == true ? 1 : 0;
	}

	/**
	 * @return the thOther
	 */
	public Integer getThOther() {
		return thOther;
	}

	/**
	 * @param thOther
	 *            the thOther to set
	 */
	public void setThOther(Boolean thOther) {
		this.thOther = thOther == true ? 1 : 0;
	}

	/**
	 * @return the wtOverweight
	 */
	public Integer getWtOverweight() {
		return wtOverweight;
	}

	/**
	 * @param wtOverweight
	 *            the wtOverweight to set
	 */
	public void setWtOverweight(Boolean wtOverweight) {
		this.wtOverweight = wtOverweight == true ? 1 : 0;
	}

	/**
	 * @return the wtUnderweight
	 */
	public Integer getWtUnderweight() {
		return wtUnderweight;
	}

	/**
	 * @param wtUnderweight
	 *            the wtUnderweight to set
	 */
	public void setWtUnderweight(Boolean wtUnderweight) {
		this.wtUnderweight = wtUnderweight == true ? 1 : 0;
	}

	/**
	 * @return the oplock
	 */
	public Integer getOplock() {
		return oplock;
	}

	/**
	 * @param oplock
	 *            the oplock to set
	 */
	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	/**
	 * @return the userprofileId
	 */
	public Long getUserprofileId() {
		return userprofileId;
	}

	/**
	 * @param userprofileId
	 *            the userprofileId to set
	 */
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	/**
	 * @return the otherHealthIssues
	 */
	public List<OtherHealthIssue> getOtherHealthIssues() {
		return otherHealthIssues;
	}

	/**
	 * @param otherHealthIssues
	 *            the otherHealthIssues to set
	 */
	public void setOtherHealthIssues(List<OtherHealthIssue> otherHealthIssues) {
		this.otherHealthIssues = otherHealthIssues;
	}
}
